/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractStage;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.impl.FXExecutorService;
import pro.gravit.launcher.gui.impl.FXMLFactory;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractVisualComponent {
    protected final JavaFXApplication application;
    protected final ContextHelper contextHelper;
    protected final FXExecutorService fxExecutor;
    protected AbstractStage currentStage;
    protected Pane layout;
    private final String sysFxmlPath;
    private Parent sysFxmlRoot;
    private CompletableFuture<Node> sysFxmlFuture;
    boolean isInit;
    boolean isPostInit;
    protected boolean isResetOnShow = false;

    protected AbstractVisualComponent(String fxmlPath, JavaFXApplication application) {
        this.application = application;
        this.sysFxmlPath = fxmlPath;
        this.contextHelper = new ContextHelper(this);
        this.fxExecutor = new FXExecutorService(this.contextHelper);
        if (application.guiModuleConfig.lazy) {
            this.sysFxmlFuture = application.fxmlFactory.getAsync(this.sysFxmlPath);
        }
    }

    public static FadeTransition fade(Node region, double delay, double from, double to, EventHandler<ActionEvent> onFinished) {
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)100.0), region);
        if (onFinished != null) {
            fadeTransition.setOnFinished(onFinished);
        }
        fadeTransition.setDelay(Duration.millis((double)delay));
        fadeTransition.setFromValue(from);
        fadeTransition.setToValue(to);
        fadeTransition.play();
        return fadeTransition;
    }

    protected void initBasicControls(Parent header) {
        if (header == null) {
            LogHelper.warning((String)"Scene %s header button(#close, #hide) deprecated", (Object[])new Object[]{this.getName()});
            LookupHelper.lookupIfPossible((Node)this.layout, "#close").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
            LookupHelper.lookupIfPossible((Node)this.layout, "#hide").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        } else {
            LookupHelper.lookupIfPossible((Node)header, "#controls", "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
            LookupHelper.lookupIfPossible((Node)header, "#controls", "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        }
        this.currentStage.enableMouseDrag((Node)this.layout);
    }

    public Pane getLayout() {
        return this.layout;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public abstract String getName();

    protected synchronized Parent getFxmlRoot() {
        try {
            if (this.sysFxmlRoot == null) {
                if (this.sysFxmlFuture == null) {
                    this.sysFxmlFuture = this.application.fxmlFactory.getAsync(this.sysFxmlPath);
                }
                this.sysFxmlRoot = (Parent)this.sysFxmlFuture.get();
            }
            return this.sysFxmlRoot;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                cause = cause.getCause();
            }
            if (cause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)cause;
                throw runtimeException;
            }
            throw new FXMLFactory.FXMLLoadException(cause);
        }
    }

    public void init() throws Exception {
        if (this.layout == null) {
            this.layout = (Pane)this.getFxmlRoot();
        }
        this.doInit();
        this.isInit = true;
    }

    public void postInit() throws Exception {
        if (!this.isPostInit) {
            this.doPostInit();
            this.isPostInit = true;
        }
    }

    protected abstract void doInit();

    protected abstract void doPostInit();

    public abstract void reset();

    public abstract void disable();

    public abstract void enable();

    public void errorHandle(Throwable e) {
        String message = null;
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        if (e instanceof RequestException) {
            message = e.getMessage();
        }
        message = message == null ? "%s: %s".formatted(e.getClass().getName(), e.getMessage()) : this.application.getTranslation("runtime.request.".concat(message), message);
        LogHelper.error((Throwable)e);
        this.application.messageManager.createNotification("Error", message);
    }

    protected Parent getFxmlRootPrivate() {
        return this.getFxmlRoot();
    }

    public boolean isDisableReturnBack() {
        return false;
    }
}

